/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.css.util.xml;

import java.net.URL;
import org.apache.xerces.parsers.SAXParser;
import org.w3c.css.util.Utf8Properties;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class XMLCatalog
extends Utf8Properties
implements ContentHandler {
    URL baseURI;

    public XMLCatalog() {
        try {
            this.baseURI = XMLCatalog.class.getResource("catalog.xml");
            this.parse(this.baseURI.toString());
        }
        catch (Exception e) {
            System.err.println("org.w3c.css.css.XMLStyleSheetHandler: couldn't load catalog.xml");
            System.err.println("  " + e.getMessage());
        }
    }

    public void setDocumentLocator(Locator locator) {
    }

    public void startDocument() throws SAXException {
    }

    public void endDocument() throws SAXException {
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
    }

    public void endPrefixMapping(String prefix) throws SAXException {
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        if ("system".equals(qName)) {
            String systemId = atts.getValue("systemId");
            String uri = atts.getValue("uri");
            if (systemId != null && uri != null) {
                try {
                    this.setProperty(systemId, new URL(this.baseURI, uri).toString());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        } else if ("public".equals(qName)) {
            String publicId = atts.getValue("publicId");
            String uri = atts.getValue("uri");
            if (publicId != null && uri != null) {
                try {
                    this.setProperty(publicId, new URL(this.baseURI, uri).toString());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
    }

    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
    }

    public void processingInstruction(String target, String data) throws SAXException {
    }

    public void skippedEntity(String name) throws SAXException {
    }

    void parse(String urlString) throws Exception {
        SAXParser xmlParser = new SAXParser();
        try {
            xmlParser.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
            xmlParser.setFeature("http://xml.org/sax/features/validation", false);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        xmlParser.setContentHandler(this);
        InputSource source = new InputSource();
        source.setSystemId(urlString);
        xmlParser.parse(source);
    }
}

